new Vue({
	el: '#childApp',
	data:function(){
		return {
			ss:'sas',
			dateTime: '',
			taskList:[],
			taskvalue: '',
			start_date: '',
      isscrollTop: false,
      currentPage:1,
      pagesize: 10,
      total: 10,
      poppage: 1,
      poppagesize: 10,
      poptotal: 10,
      poprule: '',
      poptables: '', 
      popcurrentPage: 1,
      isHidePage: true,
      scrollTop: 0,
			end_date:'',
      poploading: false,
      dialogTableVisible: false,
			takeList:[],
			dateRange:[new Date(), new Date()],
      takevalue: '',
      titleInfo: {
        "total_session": 0, 
        "validate_session": 0, 
        "ratio": 0, 
      },
			loading: true,
      poptableData: [],
      tableData: []
		}
	},
  mounted () {
    window.addEventListener('scroll', this.scrollToTop)
  },
  destroyed () {
    window.removeEventListener('scroll', this.scrollToTop)
  },
	methods: {
		changeRange(dateRange){
			this.start_date = dateRange[0];
			this.end_date = dateRange[1];
			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue, this.currentPage , 10);  // 获取统计数据
		},
		changeTask(msg){
			console.log(msg);
			this.taskvalue = msg;
			this.getTake()
			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue, this.currentPage , 10);  // 获取统计数据
		},
		changeTake(msg){
			this.takevalue = msg;
			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue, this.currentPage , 10);  // 获取统计数据
			console.log(msg);
		},
		getTask(){
			let that = this;
      that.taskList = [
        {id:'',name:'全省'},
        {id:'合肥',name:'合肥'},
        {id:'芜湖',name:'芜湖'},
        {id:'蚌埠',name:'蚌埠'},
        {id:'淮南',name:'淮南'},
        {id:'马鞍山',name:'马鞍山'},
        {id:'淮北',name:'淮北'},
        {id:'铜陵',name:'铜陵'},
        {id:'安庆',name:'安庆'},
        {id:'黄山',name:'黄山'},
        {id:'滁州',name:'滁州'},
        {id:'阜阳',name:'阜阳'},
        {id:'亳州',name:'亳州'},
        {id:'宿州',name:'宿州'},
        {id:'六安',name:'六安'},
        {id:'宣城',name:'宣城'},
        {id:'巢湖',name:'巢湖'},
        {id:'池州',name:'池州'},
        {id:'安徽省营业部',name:'安徽省营业部'},
      ];
      //RquestsGet('api/v1/tasks/obtain/').then(data => {
			//	//console.log(data);
			//	if(data.code != 0){
			//		that.taskList = [{id:'',name:'全部任务'}];
			//	}else{
			//		that.taskList = [{id:'',name:'全部任务'}].concat(data.data);
			//		that.getTake()
			//	}
			//})
		},
		getTake(){
			let that = this;
			RquestsGet('api/v1/tasks/seat/?task=' + that.taskvalue).then(data => {
				//console.log(data);

				if(data.code != 0){
					//that.takeList = [{agentName:'全部坐席'}]
				}else{
					that.takeList = data.data;
				}
			})
		},
    CurrentChange(page){
      this.currentPage = page;

			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue, this.currentPage , 10);  // 获取统计数据
    },
    popCurrentChange(page){
      this.poppage = page;
      this.getDetail(this.taskvalue,this.start_date,this.end_date,this.poptables,this.poprule, this.poppage, this.poppagesize); 
    },
		getRule(task,start_date,end_date,agentName,page,page_size){
      let that = this;

      console.log(start_date,end_date);
			let arr = [];
			this.$loading({text:'数据加载中...'});
			RquestsPost('api/v1/tasks/static_score/',{task,end_date,start_date,agentName,page,page_size}).then(data => {
				console.log(data.data);
				if(data.code != 0){
					that.$message(data.msg);
					if(data.msg){
						that.$message(data.msg);
					}else{
						that.$message('服务器错误')
					}
				}
				if(!data.data){

					this.$loading().close();
					return false;
				}
				//for(let key in data.data){
				//	arr.unshift([data.data[key],key])
				//}
        this.tableData = data.data;
        this.total = data.count;
        this.isHidePage = !(data.data.length > 0);
				this.$loading().close();
			})
			RquestsPost('api/v1/tasks/static/',{task,end_date,start_date,agentName}).then(data => {
				console.log(data.data);
				if(data.code != 0){
					that.$message(data.msg);
					if(data.msg){
						that.$message(data.msg);
					}else{
						that.$message('服务器错误')
					}
				}
				if(!data.data){

					this.$loading().close();
					return false;
				}
				that.titleInfo = data.data;
				//this.$loading().close();
			})
		},
		dateFormat(date){
			return date.getFullYear() + "-" + (date.getMonth()+1) + "-" + date.getDate();
		},
    rowDetail(index,tableData){
      let data = tableData;
      console.log(data); 

      //this.poptableData = tableData[index].details;
      this.poptables = data.tables;
      this.poprule = data.rule;
      this.taskvalue = data.area;
      this.popcurrentPage = 1;
      this.poppage = 1;
      this.getDetail(this.taskvalue,this.start_date,this.end_date,this.poptables,this.poprule, this.poppage, this.poppagesize);
      this.dialogTableVisible = true;

    },
    getDetail(task,start_date,end_date, tables, rule, page, page_size){
			//this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
      let that = this;
			//this.$loading({text:'数据加载中...'});
      this.poploading = true;
			RquestsPost('api/v1/tasks/score_detail/',{task,end_date,start_date,tables,rule,page,page_size}).then(data => {
				console.log(data.data);
				if(data.code != 0){
					that.$message(data.msg);
					if(data.msg){
						that.$message(data.msg);
					}else{
						that.$message('服务器错误')
					}
				}
				//that.titleInfo = data.data;
        that.poptotal = data.count;
        that.poptableData = data.data;
				//this.$loading().close();
        this.poploading = false;
			})
    },
    handleTableDetail(index, msg){
      let url = "/quality/audio/check-detail/"+msg.sessionCollectionId+"/"+msg.taskId+"?from=checkTask&sessionId=" + msg.sessionId;
      console.log(url);
      let autoMessage = {
        jumplink: url
      };
      window.parent.postMessage(autoMessage,'*');
    },
    backTop () {
        const that = this
        let timer = setInterval(() => {
          let ispeed = Math.floor(-that.scrollTop / 5)
          document.documentElement.scrollTop = document.body.scrollTop = that.scrollTop + ispeed
          if (that.scrollTop === 0) {
            clearInterval(timer)
          }
        }, 16)
    },

    // 为了计算距离顶部的高度，当高度大于60显示回顶部图标，小于60则隐藏
    scrollToTop () {
      const that = this
      let scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop
      that.scrollTop = scrollTop
      if (that.scrollTop > 60) {
        that.isscrollTop = true
      } else {
        that.isscrollTop = false
      }
    },
		init(){
			this.dateRange = [new Date(new Date()-24*60*60*1000), new Date()];
			this.start_date = this.dateFormat(new Date(new Date()-24*60*60*1000));
			this.end_date = this.dateFormat(new Date());
			this.getTask();  // 获取任务
			//this.getTake();  // 获取坐席

			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue, this.currentPage , 10);  // 获取统计数据

		}
	},
	created(){
		this.init()
	},

})
