new Vue({
	el: '#childApp',
	data:function(){
		return {
			ss:'sas',
			dateTime: '',
			taskList:[],
      isscrollTop: false,
      scrollTop: 0,
			taskvalue: '',
			dateRange:[new Date(), new Date()],
			start_date: '',
			end_date:'',
			takeList:[],
      takevalue: '',
			loading: true,
      allData: [],
      basearr: [
        {
            createdAt: '质检考核项目编号',
            fwyy:'1', 
            kcb:'2', 
            jsy:'3', 
            fwtd:'4', 
            yssb:'5', 
            jysb:'6', 
            yycl:'7', 
            ywcc:'8', 
            yyjlz:'9', 
            fwjs:'10', 
            wtgbj:'11', 
            wzyhfljs:'12', 
            wgzlf:'13', 
            mgc:'14', 
        }, {
            createdAt: '质检考核权重',
            fwyy:'10%', 
            kcb:'10%', 
            jsy:'5%', 
            fwtd:'10%', 
            yssb:'5%', 
            jysb:'5%', 
            yycl:'10%', 
            ywcc:'15%', 
            yyjlz:'15%', 
            fwjs:'5%', 
            wtgbj:'5%', 
            wzyhfljs:'5%', 
            wgzlf:'100%', 
            mgc:'100%', 
        }],
      tableData: [],
      currentPage:1,
      pagesize: 15,
      total: 10,
      isHidePage: true,
		}
	},
  mounted () {
    window.addEventListener('scroll', this.scrollToTop)
  },
  destroyed () {
    window.removeEventListener('scroll', this.scrollToTop)
  },

	methods: {
		changeRange(dateRange){
			this.start_date = dateRange[0];
			this.end_date = dateRange[1];
      this.currentPage = 1;
			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
		},
		changeTask(msg){
			this.taskvalue = msg;
      this.currentPage = 1;
			this.getTake()
			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
		},
		changeTake(msg){
			this.takevalue = msg;
      this.currentPage = 1;
			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
		},
		getTask(){
			let that = this;
      that.taskList = [
        {id:'',name:'全省'},
        {id:'合肥',name:'合肥'},
        {id:'芜湖',name:'芜湖'},
        {id:'蚌埠',name:'蚌埠'},
        {id:'淮南',name:'淮南'},
        {id:'马鞍山',name:'马鞍山'},
        {id:'淮北',name:'淮北'},
        {id:'铜陵',name:'铜陵'},
        {id:'安庆',name:'安庆'},
        {id:'黄山',name:'黄山'},
        {id:'滁州',name:'滁州'},
        {id:'阜阳',name:'阜阳'},
        {id:'亳州',name:'亳州'},
        {id:'宿州',name:'宿州'},
        {id:'六安',name:'六安'},
        {id:'宣城',name:'宣城'},
        {id:'巢湖',name:'巢湖'},
        {id:'池州',name:'池州'},
        {id:'安徽省营业部',name:'安徽省营业部'},
      ];
		},
		getRule(task,start_date,end_date,agentName){
			let that = this;
      let page = this.currentPage;
      let page_size = this.pagesize;
			this.$loading({text:'数据加载中...'});
			RquestsPost('api/v1/tasks/seat_check/',{task,start_date,end_date,agentName,page,page_size}).then(data => {
			  that.$loading().close();

				if(data.code != 0){
				}else{

					//that.tableData = this.basearr.concat(data.data.slice((this.currentPage-1)*this.pagesize,this.currentPage*this.pagesize));
					that.tableData = this.basearr.concat(data.data);
					that.allData = data.data;
          this.total = data.count;
          this.isHidePage = !(data.data.length > 0);
					//that.takeList = data.data;
				}
			})
		},
		getTake(){
			let that = this;
			RquestsGet('api/v1/tasks/seat/?task=' + that.taskvalue+'&start_date='+this.start_date+'&end_date='+this.end_date).then(data => {
			//RquestsGet('api/v1/tasks/seat/?task=' + that.taskvalue).then(data => {
				//console.log(data);

				if(data.code != 0){
					//that.takeList = [{agentName:'全部坐席'}]
				}else{
					that.takeList = data.data;
				}
			})
		},
    arraySpanMethod({ row, column, rowIndex, columnIndex }) {
      if (rowIndex === 0 || rowIndex === 1) { // 在这里多加一个行的判断就行
        // 合并第二行
        if (columnIndex === 0) {
          // 从第二列开始
          return [1, 3]
        }
        else if (columnIndex === 2 || columnIndex === 3   ) {
          return [0, 0]
        }
      } 
    },
		dateFormat(date){
			return date.getFullYear() + "-" + (date.getMonth()+1) + "-" + date.getDate();
		},

    backTop () {
        const that = this
        let timer = setInterval(() => {
          let ispeed = Math.floor(-that.scrollTop / 5)
          document.documentElement.scrollTop = document.body.scrollTop = that.scrollTop + ispeed
          if (that.scrollTop === 0) {
            clearInterval(timer)
          }
        }, 16)
    },

    // 为了计算距离顶部的高度，当高度大于60显示回顶部图标，小于60则隐藏
    scrollToTop () {
      const that = this
      let scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop
      that.scrollTop = scrollTop
      if (that.scrollTop > 60) {
        that.isscrollTop = true
      } else {
        that.isscrollTop = false
      }
    },
    CurrentChange(page){
      this.currentPage = page;
			//this.tableData = this.basearr.concat(this.allData.slice((page-1)*this.pagesize,page*this.pagesize));
			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
			//that.allData = data.data;
    },
    rowClick(row, column, event){
      console.log(row) ;
      let url = "/quality/audio/check-detail/"+row.sessionCollectionId+"/"+row.taskId+"?from=checkTask&sessionId=" + row.sessionId;
      let autoMessage = {
        jumplink: url
      };
        console.log(autoMessage);
      window.parent.postMessage(autoMessage,'*');
    },
		init(){
			this.dateRange = [new Date(new Date()-24*60*60*1000), new Date()];
			this.start_date = this.dateFormat(new Date(new Date()-24*60*60*1000));
			this.end_date = this.dateFormat(new Date());
			this.getTask();  // 获取任务
			this.getTake();  // 获取坐席
			this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据


		}
	},
	created(){
		this.init()
	},

})
