new Vue({
	el: '#childApp',
	data:function(){
		return {
			ss:'sas',
			dateTime: '',
			cityList:[],
            countryList:[],
			cityvalue: null,
            countryvalue: null,
            country_show: false,
			start_date: '',
      isscrollTop: false,
      currentPage:1,
      pagesize: 10,
      total: 10,
      poppage: 1,
      poppagesize: 10,
      poptotal: 10,
      poprule: '',
      poptables: '',
      popcurrentPage: 1,
      isHidePage: true,
      scrollTop: 0,
			end_date:'',
      poploading: false,
      BASEURL: window_url,
      dialogTableVisible: false,
			takeList:[],
			dateRange:[new Date(), new Date()],
      titleInfo: {
        "total_session": 0,
        "validate_session": 0,
        "ratio": 0,
      },
			loading: true,
      poptableData: [],
      tableData: []
		}
	},
  mounted () {
    window.addEventListener('scroll', this.scrollToTop)
  },
  destroyed () {
    window.removeEventListener('scroll', this.scrollToTop)
  },
	methods: {
		loadData(){
          this.$refs.loadModal.submit();
          this.$message('文件下载中请稍后...');
    	},
		changeRange(dateRange){
			this.start_date = dateRange[0];
			this.end_date = dateRange[1];
			this.getRule(this.cityvalue,this.countryvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
		},
		changeCity(msg){
			console.log(msg);
			this.cityvalue = msg;
			this.countryvalue = null;
			this.getCountry(this.cityvalue);
			this.getRule(this.cityvalue,this.countryvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
		},
        changeCountry(msg){
			console.log(msg);
			this.countryvalue = msg;
			this.getRule(this.cityvalue,this.countryvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
		},
        getCountry() {
            let that = this;
            RquestsGet('api/v1/agency/country/?city_id=' + this.cityvalue).then(data => {
                //console.log(data);

                if (data.code != 0) {
                    that.$message('服务器错误')
                } else {
                    that.countryList = data.data.country_list;
                    if (that.countryList.length > 0) {
                    that.country_show = true;
                } else {
                    that.country_show = false;
                };
                }
            })
        },
		getCity(){
			let that = this;
			var request = new XMLHttpRequest();

			let uri = window_url + 'api/v1/agency/city/';

            request.open('GET', uri, false);
            request.send(null);
            if (request.status === 200) {
              data = JSON.parse(request.response);
              console.log(data.code);
              if(data.code != 0){
                that.$message('服务器错误');
              } else {
                that.cityList = data.data.city_list;
                that.countryList = data.data.country_list;
                if (that.countryList.length > 0) {
                    that.country_show = true;
                } else {
                    that.country_show = false;
                };
                that.cityvalue = data.data.city_id;
                console.log(that.cityvalue);
                that.init_simple = true;
              }
            } else {
                that.$message('服务器错误');
            }
      //RquestsGet('api/v1/tasks/obtain/').then(data => {
			//	//console.log(data);
			//	if(data.code != 0){
			//		that.taskList = [{id:'',name:'全部任务'}];
			//	}else{
			//		that.taskList = [{id:'',name:'全部任务'}].concat(data.data);
			//		that.getTake()
			//	}
			//})
		},
    CurrentChange(page){
      this.currentPage = page;
    },
    popCurrentChange(page){
      this.poppage = page;
      this.getDetail(this.cityvalue,this.countryvalue,this.end_date,this.poptables,this.poprule, this.poppage, this.poppagesize);
    },
	getRule(city,country,start_date,end_date,agentName){
      let that = this;

      console.log(start_date,end_date);
			let arr = [];
			this.$loading({text:'数据加载中...'});
			RquestsPost('api/v1/tasks/static_rule/',{city,country,end_date,start_date,agentName}).then(data => {
				console.log(data.data);
				if(data.code != 0){
					that.$message(data.msg);
					if(data.msg){
						that.$message(data.msg);
					}else{
						that.$message('服务器错误')
					}
				}
				if(!data.data){

					this.$loading().close();
					return false;
				}
				//for(let key in data.data){
				//	arr.unshift([data.data[key],key])
				//}
        this.tableData = data.data;
        this.total = data.data.length;
        this.isHidePage = !(data.data.length > 0);
				this.$loading().close();
			})
			RquestsPost('api/v1/tasks/static/',{city,country,end_date,start_date,agentName}).then(data => {
				console.log(data.data);
				if(data.code != 0){
					that.$message(data.msg);
					if(data.msg){
						that.$message(data.msg);
					}else{
						that.$message('服务器错误')
					}
				}
				if(!data.data){

					this.$loading().close();
					return false;
				}
				that.titleInfo = data.data;
				//this.$loading().close();
			})
		},
		dateFormat(date){
			return date.getFullYear() + "-" + (date.getMonth()+1) + "-" + date.getDate();
		},
    rowDetail(index,tableData){
      let data = tableData[index + (this.currentPage-1) * this.pagesize];
      console.log(data);

      //this.poptableData = tableData[index].details;
      this.poptables = data.tables;
      this.poprule = data.rule;
      this.popcurrentPage = 1;
      this.poppage = 1;
      //this.taskvalue = tableData.area;
      this.getDetail(this.cityvalue,this.countryvalue,this.start_date,this.end_date,this.poptables,this.poprule, this.poppage, this.poppagesize);

    },
    getDetail(city,country,start_date,end_date, tables, rule, page, page_size){
			//this.getRule(this.taskvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据
      let that = this;
			this.$loading({text:'数据加载中...'});
      this.poploading = true;
			RquestsPost('api/v1/tasks/rule_detail/',{city,country,end_date,start_date,tables,rule,page,page_size}).then(data => {
				console.log(data.data);
			  this.$loading().close();
        this.dialogTableVisible = true;
				if(data.code != 0){
					that.$message(data.msg);
					if(data.msg){
						that.$message(data.msg);
					}else{
						that.$message('服务器错误')
					}
				}
				//that.titleInfo = data.data;
        that.poptotal = data.count;
        that.poptableData = data.data;
				//this.$loading().close();
        this.poploading = false;
			})
    },
    handleTableDetail(index, msg){
      let url = "/quality/audio/check-detail/"+msg.sessionCollectionId+"/"+msg.taskId+"?from=checkTask&sessionId=" + msg.sessionId;
      console.log(url);
      let autoMessage = {
        jumplink: url
      };
      window.parent.postMessage(autoMessage,'*');
    },
    backTop () {
        const that = this
        let timer = setInterval(() => {
          let ispeed = Math.floor(-that.scrollTop / 5)
          document.documentElement.scrollTop = document.body.scrollTop = that.scrollTop + ispeed
          if (that.scrollTop === 0) {
            clearInterval(timer)
          }
        }, 16)
    },

    // 为了计算距离顶部的高度，当高度大于60显示回顶部图标，小于60则隐藏
    scrollToTop () {
      const that = this
      let scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop
      that.scrollTop = scrollTop
      if (that.scrollTop > 60) {
        that.isscrollTop = true
      } else {
        that.isscrollTop = false
      }
    },
		init(){
			this.dateRange = [new Date(new Date()-24*60*60*1000), new Date()];
			this.start_date = this.dateFormat(new Date(new Date()-24*60*60*1000));
			this.end_date = this.dateFormat(new Date());
			this.getCity();  // 获取任务
			//this.getTake();  // 获取坐席

			this.getRule(this.cityvalue,this.countryvalue,this.start_date,this.end_date,this.takevalue);  // 获取统计数据

		}
	},
	created(){
		this.init()
	},

})
