new Vue({
    el: '#childApp',
    data: function () {
        return {
            ss: 'sas',
            dateTime: '',
            cityList: [],
            countryList: [],
            cityvalue: null,
            countryvalue: '',
            country_show: false,
            isscrollTop: false,
            popseatName: '',
            scrollTop: 0,
            dateRange: [new Date(), new Date()],
            start_date: '',
            end_date: '',
            seatList: [],
            seatvalue: null,
            seat_show: true,
            teamvalue: null,
            loading: true,
            tableData: [],
            poploading: false,
            BASEURL: window_url,
            start_date: '',
            sortObj: {
                name: '',
                sort: 'avg_score_bus',
            },
            currentPage: 1,
            page: 1,
            page_size: 10,
            pagesize: 10,
            total: 10,
            isHidePage: true,
            dialogTableVisible: false,
            poptableData: [],
            popcurrentPage: 1,
            poptables: '',
            poppage: 1,
            poppagesize: 10,
            poptotal: 10,
            poprule: '',
            agentName: '',
            sel_is_show: true,
        }
    },
    mounted() {
        window.addEventListener('scroll', this.scrollToTop)
    },
    destroyed() {
        window.removeEventListener('scroll', this.scrollToTop)
    },
    methods: {
        loadData() {
            this.$refs.loadModal.submit();
            this.$message('文件下载中请稍后...');
        },
        sortChange(item) {
            console.log(item);
            let order;
            if (item.order == 'descending') {
                order = item.prop;
            } else if (item.order == 'ascending') {
                order = '-' + item.prop;
            } else {
                order = null;
            }
            this.sortObj = {
                name: item.prop,
                sort: order
            }
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue, this.page, this.page_size);  // 获取统计数据
        },
        changeRange(dateRange) {
            this.start_date = dateRange[0];
            this.end_date = dateRange[1];
            this.seatvalue = null;
            this.page = 1;
            this.getTake();
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue, this.page, this.page_size);  // 获取统计数据
        },
        changeCity(msg) {
            this.cityvalue = msg;
            this.countryvalue = '';
            this.seatvalue = null;
            this.getCountry();
            this.getTake();
            this.page = 1;
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue, this.page, this.page_size);  // 获取统计数据
        },
        changeCountry(msg) {
            this.countryvalue = msg;
            this.seatvalue = null;
            this.getTake();
            this.page = 1;
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue, this.page, this.page_size);  // 获取统计数据
        },
        changeSeat(msg) {
            this.seatvalue = msg;
            this.page = 1;
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue, this.page, this.page_size);  // 获取统计数据
        },
        getCountry() {
            let that = this;
            RquestsGet('api/v1/agency/country/?city_id=' + this.cityvalue).then(data => {
                //console.log(data);

                if (data.code != 0) {
                    that.$message('服务器错误')
                } else {
                    that.countryList = data.data.country_list;
                    if (that.countryList.length > 0) {
                        that.country_show = true;
                    } else {
                        that.country_show = false;
                    };
                }
            })
        },
        getCity() {
            let that = this;
            var request = new XMLHttpRequest();

            let uri = window_url + 'api/v1/agency/city/';

            request.open('GET', uri, false);
            request.send(null);
            if (request.status === 200) {
                data = JSON.parse(request.response);
                console.log(data.code);
                if (data.code != 0) {
                    that.$message('服务器错误');
                } else {
                    that.cityList = data.data.city_list;
                    that.countryList = data.data.country_list;
                    if (that.countryList.length > 0) {
                        that.country_show = true;
                    } else {
                        that.country_show = false;
                    };
                    that.cityvalue = data.data.city_id;
                    console.log(that.cityvalue);
                    that.init_simple = true;
                }
            } else {
                that.$message('服务器错误');
            }
        },
        getRule(city, country, start_date, end_date, seat, page, page_size) {
            let that = this;
            // 获取表格数据
            let sort = this.sortObj.sort;
            this.$loading({text: '数据加载中...'});
            RquestsPost('api/v1/tasks/seat_area/', {
                city,
                country,
                start_date,
                end_date,
                seat,
                page,
                page_size,
                sort
            }).then(data => {

                if (data.code != 0) {
                } else {
                    that.tableData = data.data;
                    this.total = data.count;
                    this.isHidePage = !(data.data.length > 0);
                }
                that.$loading().close();
            })
        },
        getTake() {
            let that = this;
            RquestsGet('api/v1/tasks/seat/?city=' + that.cityvalue + '&country=' + that.countryvalue + '&start_date=' + this.start_date + '&end_date=' + this.end_date).then(data => {
                //console.log(data);

                if (data.code != 0) {
                    //that.takeList = [{agentName:'全部坐席'}]
                } else {
                    that.seatList = data.data;
                    if (that.seatList.length > 0) {
                        that.seat_show = true;
                    } else {
                        that.seat_show = false;
                    };
                }

            })
        },
        arraySpanMethod({row, column, rowIndex, columnIndex}) {
            if (rowIndex === 0 || rowIndex === 1) { // 在这里多加一个行的判断就行
                // 合并第二行
                if (columnIndex === 0) {
                    // 从第二列开始
                    return [1, 6]
                } else if (columnIndex === 2 || columnIndex === 3 || columnIndex === 4 || columnIndex === 5 || columnIndex === 6) {
                    return [0, 0]
                }
            }
        },
        dateFormat(date) {
            return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
        },
        backTop() {
            const that = this
            let timer = setInterval(() => {
                let ispeed = Math.floor(-that.scrollTop / 5)
                document.documentElement.scrollTop = document.body.scrollTop = that.scrollTop + ispeed
                if (that.scrollTop === 0) {
                    clearInterval(timer)
                }
            }, 16)
        },

        // 为了计算距离顶部的高度，当高度大于60显示回顶部图标，小于60则隐藏
        scrollToTop() {
            const that = this
            let scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop
            that.scrollTop = scrollTop
            if (that.scrollTop > 60) {
                that.isscrollTop = true
            } else {
                that.isscrollTop = false
            }
        },
        CurrentChange(page) {
            this.currentPage = page;
            this.page = page;
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue, this.page, this.page_size);  // 获取统计数据
        },
        rowDetail(index, tableData) {
            this.agentName = tableData.agentName;
            this.popseatName = tableData.seatName;
            this.teamvalue = tableData.area;
            this.getDetail(this.start_date, this.end_date, this.poptables, this.poprule, this.poppage, this.poppagesize, this.agentName);

        },
        popCurrentChange(page) {
            this.poppage = page;
            this.getDetail(this.start_date, this.end_date, this.poptables, this.poprule, this.poppage, this.poppagesize, this.agentName);
        },
        getDetail(start_date, end_date, tables, rule, page, page_size, agentName, seatName) {
            let that = this;
            this.$loading({text: '数据加载中...'});
            this.poploading = true;
            RquestsPost('api/v1/tasks/score_detail/', {
                end_date,
                start_date,
                tables,
                rule,
                page,
                page_size,
                agentName
            }).then(data => {
                console.log(data.data);
                this.dialogTableVisible = true;
                this.$loading().close();
                if (data.code != 0) {
                    that.$message(data.msg);
                    if (data.msg) {
                        that.$message(data.msg);
                    } else {
                        that.$message('服务器错误')
                    }
                }
                //that.titleInfo = data.data;
                that.poptotal = data.count;
                that.poptableData = data.data;
                for(let i = 0, len = that.poptableData.length; i < len; i++){
                    that.poptableData[i].seatName = that.popseatName
                }
                //this.$loading().close();
                this.poploading = false;
            })
        },
        handleTableDetail(index, msg) {
            let url = "/quality/audio/check-detail/" + msg.sessionCollectionId + "/" + msg.taskId + "?from=checkTask&sessionId=" + msg.sessionId;
            console.log(url);
            let autoMessage = {
                jumplink: url
            };
            window.parent.postMessage(autoMessage, '*');
        },
        init() {
            this.dateRange = [new Date(new Date() - 24 * 60 * 60 * 1000), new Date()];
            this.start_date = this.dateFormat(new Date(new Date() - 24 * 60 * 60 * 1000));
            this.end_date = this.dateFormat(new Date());
            this.getCity();  // 获取任务
            this.getTake();  // 获取坐席
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue, this.page, this.page_size);  // 获取统计数据


        }
    },
    created() {
        this.init()
    },

})
