new Vue({
    el: '#childApp',
    data: function () {
        return {
            ss: 'sas',
            dateRange: [new Date(), new Date()],
            cityList: [],
            countryList: [],
            cityvalue: '',
            countryvalue: '',
            country_show: false,
            start_date: '',
            end_date: '',
            seatList: [],
            seat_show: true,
            seatvalue: '',
            loading: true,
            tableData: [],
            sortObj: {
                name: '',
                sort: 'des',
            },
            BASEURL: window_url,
            currentPage: 1,
            pagesize: 15,
            total: 10,
            isHidePage: true,
        }
    },
    methods: {
        loadData() {
            this.$refs.loadModal.submit();
            this.$message('文件下载中请稍后...');
        },
        changeRange(dateRange) {
            console.log(dateRange);
            this.start_date = dateRange[0];
            this.end_date = dateRange[1];
            this.seatvalue = null;
            this.currentPage = 1;
            this.getTake();
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue);  // 获取统计数据
        },
        changeCity(msg) {
            console.log(msg);
            this.currentPage = 1;
            this.cityvalue = msg;
            this.countryvalue = '';
            this.seatvalue = null;
            this.getCountry();
            this.getTake();
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue);  // 获取统计数据
        },
        changeCountry(msg) {
            this.countryvalue = msg;
            this.seatvalue = null;
            this.getTake();
            this.currentPage = 1;
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue);  // 获取统计数据
        },
        changeSeat(msg) {
            this.currentPage = 1;
            this.seatvalue = msg;
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue);  // 获取统计数据
            console.log(msg);
        },
        getCity(){
			let that = this;
			var request = new XMLHttpRequest();

			let uri = window_url + 'api/v1/agency/city/';

            request.open('GET', uri, false);
            request.send(null);
            if (request.status === 200) {
              data = JSON.parse(request.response);
              console.log(data.code);
              if(data.code != 0){
                that.$message('服务器错误');
              } else {
                that.cityList = data.data.city_list;
                that.countryList = data.data.country_list;
                if (that.countryList.length > 0) {
                    that.country_show = true;
                } else {
                    that.country_show = false;
                };
                that.cityvalue = data.data.city_id;
                console.log(that.cityvalue);
                that.init_simple = true;
              }
            } else {
                that.$message('服务器错误');
            }
		},
        getTake() {
            let that = this;
            RquestsGet('api/v1/tasks/seat/?city=' + that.cityvalue + '&country=' + that.countryvalue + '&start_date=' + this.start_date + '&end_date=' + this.end_date).then(data => {
                //console.log(data);

                if (data.code != 0) {
                    //that.takeList = [{agentName:'全部坐席'}]
                } else {
                    that.seatList = data.data;
                    if (that.seatList.length > 0) {
                        that.seat_show = true;
                    } else {
                        that.seat_show = false;
                    };
                }

            })
        },
        sortChange(item) {
            console.log(item);
            let order;
            if (item.order == 'descending') {
                order = 'des';
            } else if (item.order == 'ascending') {
                order = 'asc';
            } else {
                order = null;
            }
            this.sortObj = {
                name: item.prop,
                sort: order
            }
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue);  // 获取统计数据
        },
        getRule(city, country, start_date, end_date, agentName) {
            let that = this;
            let page = this.currentPage;
            let arr = [];
            this.$loading({text: '数据加载中...'});
            let sort = this.sortObj.sort;
            RquestsPost('api/v1/tasks/seat_rule/', {city, country, start_date, end_date, agentName, page, sort}).then(data => {
                console.log(data.data);
                if (data.code != 0) {
                    that.$message(data.msg);
                    if (data.msg) {
                        that.$message(data.msg);
                    } else {
                        that.$message('服务器错误')
                    }
                }
                this.tableData = data.data;
                this.total = data.count;
                this.isHidePage = !(data.data.length > 0);
                if (!data.data) {

                    this.$loading().close();
                    return false;
                }
                //for(let key in data.data){
                //	arr.unshift([data.data[key],key])
                //}

                this.$loading().close();
            })
        },
        CurrentChange(page) {
            this.currentPage = page;
            //this.tableData = this.basearr.concat(this.allData.slice((page-1)*this.pagesize,page*this.pagesize));
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue);  // 获取统计数据
            //that.allData = data.data;
        },
        dateFormat(date) {
            return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
        },
        init() {
            this.dateRange = [new Date(new Date() - 24 * 60 * 60 * 1000), new Date()];
            this.start_date = this.dateFormat(new Date(new Date() - 24 * 60 * 60 * 1000));
            this.end_date = this.dateFormat(new Date());
            this.getCity();  // 获取任务
            this.getTake();  // 获取坐席

            console.log(this.dateRange);
            this.getRule(this.cityvalue, this.countryvalue, this.start_date, this.end_date, this.seatvalue);  // 获取统计数据

        }
    },
    created() {
        this.init()
    },

})
