# coding: utf-8
from django.shortcuts import render
from rest_framework import viewsets
from rest_framework.decorators import action
from rest_framework.request import Request
from rest_framework.response import Response
from inspect_report.models import Tasks, CheckSession
import json
from datetime import datetime, timedelta
from config.config import TABLE_PRE
from django.views.decorators.clickjacking import xframe_options_exempt
from inspect_report import permissions
import logging

logger = logging.getLogger(__name__)


class TasksApi(viewsets.ViewSet):
    authentication_classes = ()
    permission_classes = ()
    # permission_classes = (permissions.ValidateToken, )

    @action(['get'], detail=False)
    def obtain(self, req: Request):
        """
        查询任务列表
        :param req:
        :return:
        """
        tasks = Tasks.objects.all().order_by('-createdAt').values('id', 'name')
        # return render(req, 'inspect/index.html', {'tasks': tasks})
        return Response({'code': 0, 'msg': 'success', 'data': tasks})

    @action(['get'], detail=False)
    def seat(self, req: Request):
        """
        获取坐席列表
        :param req:
        :return:
        """
        task_id = req.GET.get('task', '')
        task_condition = {}
        if task_id:
            task_condition['pk'] = task_id
        tasks = Tasks.objects.filter(**task_condition)
        return_data = []
        for t in tasks:
            session_collection = t.sessionCollectionId
            table_name = TABLE_PRE + session_collection
            tn = CheckSession.set_table(table_name)
            agents = tn.objects.filter(taskId=t.id).values('agentName')
            for agent in agents:
                if agent not in return_data:
                    return_data.append(agent)
        return Response({'code': 0, 'msg': 'success', 'data': return_data})

    @action(['post'], detail=False)
    def rule(self, req: Request):
        """
        获取违规项分析
        :param req:
        :return:
        """
        task_id = req.data.get('task', '')
        agent_name = req.data.get('agentName', '')
        start_date = req.data.get('start_date', (datetime.now()+timedelta(days=-30)).strftime('%Y-%m-%d'))
        end_date = req.data.get('end_date', datetime.now().strftime('%Y-%m-%d'))
        task_condition = {'createdAt__gte': start_date, 'createdAt__lt': end_date + ' 23:59:59'}
        tasks = []
        if task_id:
            tk = Tasks.objects.get(pk=task_id)
            tasks.append(tk)
        else:
            tasks = Tasks.objects.filter(**task_condition)
        return_data = {}
        for t in tasks:
            session_collection = t.sessionCollectionId
            table_name = TABLE_PRE + session_collection
            tn = CheckSession.set_table(table_name)
            session_condition = {'taskId': t.id}
            if agent_name:
                session_condition['agentName'] = agent_name
            checks = tn.objects.filter(**session_condition)
            for check in checks:
                result = check.checkResult
                if result:
                    data = json.loads(result)
                    for d in data:
                        if 'isViolation' in d.keys() and d['isViolation'] and 'rule' in d.keys() and 'name' in d['rule'].keys():
                            name = d['rule']['name']
                            if name in return_data.keys():
                                return_data[name] += 1
                            else:
                                return_data[name] = 1
        data_sort = sorted(return_data.items(), key=lambda item: item[1], reverse=False)
        return Response({'code': 0, 'msg': 'success', 'data': data_sort})

    @action(['post'], detail=False)
    def seat_session(self, req: Request):
        """
        坐席违规分析-按照会话
        :param req:
        :return:
        """
        task_id = req.data.get('task', '')
        num = req.data.get('num', '10')
        start_date = req.data.get('start_date', (datetime.now()+timedelta(days=-30)).strftime('%Y-%m-%d'))
        end_date = req.data.get('end_date', datetime.now().strftime('%Y-%m-%d'))
        task_condition = {'createdAt__gte': start_date, 'createdAt__lt': end_date + ' 23:59:59'}
        tasks = []
        if task_id:
            tk = Tasks.objects.get(pk=task_id)
            tasks.append(tk)
        else:
            tasks = Tasks.objects.filter(**task_condition)
        return_data = {}
        for t in tasks:
            session_collection = t.sessionCollectionId
            table_name = TABLE_PRE + session_collection
            tn = CheckSession.set_table(table_name)
            session_condition = {'taskId': t.id}
            checks = tn.objects.filter(**session_condition)
            for check in checks:
                agent_name = check.agentName
                if agent_name:
                    if agent_name in return_data.keys():
                        return_data[agent_name] += 1
                    else:
                        return_data[agent_name] = 1
        data_max = sorted(return_data.items(), key=lambda item: item[1], reverse=False)
        data_max = data_max[-int(num):]
        data_max_return = {}
        for dm in data_max:
            data_max_return[dm[0]] = dm[1]
        return Response({'code': 0, 'msg': 'success', 'data': data_max_return})

    @action(['post'], detail=False)
    def seat_score(self, req: Request):
        """
        坐席违规分析-按照得分
        :param req:
        :return:
        """
        task_id = req.data.get('task', '')
        num = req.data.get('num', '10')
        start_date = req.data.get('start_date', (datetime.now()+timedelta(days=-30)).strftime('%Y-%m-%d'))
        end_date = req.data.get('end_date', datetime.now().strftime('%Y-%m-%d'))
        task_condition = {'createdAt__gte': start_date, 'createdAt__lt': end_date + ' 23:59:59'}
        tasks = []
        if task_id:
            tk = Tasks.objects.get(pk=task_id)
            tasks.append(tk)
        else:
            tasks = Tasks.objects.filter(**task_condition)
        return_data = {}
        for t in tasks:
            session_collection = t.sessionCollectionId
            table_name = TABLE_PRE + session_collection
            tn = CheckSession.set_table(table_name)
            session_condition = {'taskId': t.id}
            checks = tn.objects.filter(**session_condition)
            for check in checks:
                agent_name = check.agentName
                if agent_name:
                    if agent_name in return_data.keys():
                        return_data[agent_name] += check.score
                    else:
                        return_data[agent_name] = check.score
        data_max = sorted(return_data.items(), key=lambda item: item[1], reverse=False)
        data_max = data_max[:int(num)]
        data_max_return = {}
        for dm in data_max:
            data_max_return[dm[0]] = dm[1]
        return Response({'code': 0, 'msg': 'success', 'data': data_max_return})


@xframe_options_exempt
def rule(request):
    return render(request, 'inspect/rule.html')


@xframe_options_exempt
def seat(request):
    return render(request, 'inspect/seat.html')
