# -*- coding: utf-8 -*-
import logging
from rest_framework.permissions import BasePermission
from rest_framework.authentication import exceptions

log = logging.getLogger(__name__)


class ValidateToken(BasePermission):
    """ token 正确才可以调用 """
    def has_permission(self, request, view):
        try:
            http_auth = request.GET.get('token', '')
            if http_auth:
                # token = http_auth.split(' ')[1]
                # if http_auth.split(' ')[0] != 'Token':
                #     log.error('token 认证异常 | HTTP_WXAUTH 中缺少 Token')
                #     raise exceptions.AuthenticationFailed(detail={'code': -5, 'msg': 'token 认证异常'})
                # key = request.session.get(token, None)
                # if not key:
                #     log.error('token 认证异常 | Token不存在或者已过期')
                #     raise exceptions.AuthenticationFailed(detail={'code': -5, 'msg': '无效的token'})
                return True
        except KeyError as ke:
            log.error('token 认证异常 | header中缺少HTTP_WXAUTH | 异常信息 : KeyError : %s', str(ke))
            raise exceptions.AuthenticationFailed(detail={'code': -5, 'msg': 'token 认证异常'})
        except IndexError as ie:
            log.error('token 认证异常 | HTTP_WXAUTH 中值错误 : %s | 异常信息 : IndexError : %s',
                      request.META['HTTP_WXAUTH'], str(ie))
            raise exceptions.AuthenticationFailed(detail={'code': -5, 'msg': 'token 认证异常'})
        except Exception as e:
            log.error('token 认证异常 : %s', str(e))
            raise exceptions.AuthenticationFailed(detail={'code': -5, 'msg': 'token 认证异常'})
        raise exceptions.AuthenticationFailed(detail={'code': -5, 'msg': 'token 认证异常'})
